# FAQ-Accordion

## Willkommen! 👋

Willkommen zu diesem Frontend-Mini-Projekt.

Sie bauen ein **Frequently-Asked-Questions (FAQ)-Accordion**: eine Liste von Fragen, bei der sich die Antworten **auf- und zuklappen** lassen.

**Für dieses Projekt brauchen Sie Grundkenntnisse in HTML, CSS und JavaScript.**

## Das Projekt

Ihre Aufgabe ist es, das FAQ-Accordion umzusetzen und das Ergebnis so nah wie sinnvoll an das vorgegebene Design zu bringen.

Benutzerinnen und Benutzer sollen Folgendes können:

- Antworten ein- und ausblenden, indem sie auf eine Frage klicken
- Die Fragen **nur mit der Tastatur** navigieren und Antworten ein-/ausklappen
- Je nach Bildschirmgrösse ein optimales Layout sehen (responsive)
- Hover- und Focus-States für alle interaktiven Elemente erkennen

## Wo Sie alles finden

Die Designs finden Sie im figma-File "faq-accordion_m291.fig" Das bedeutet, dass Sie bei Details wie `font-size`, `padding` und `margin` die Infos aus dem Design herauslesen müssen.

Alle benötigten Assets (Icons/Bilder) finden Sie im Ordner `/assets`. Diese sind bereits passend exportiert und optimiert.

Zusätzlich sind Schriftdateien enthalten (Variable Fonts und ausgewählte statische Fonts). Sie können entweder:

- Schriften über einen Webdienst (z. B. Google Fonts) einbinden oder
- die Fonts lokal hosten und die mitgelieferten Dateien nutzen

## Empfohlener Ablauf

Sie können frei arbeiten – hier eine sinnvolle Vorgehensweise:

1. Projektordner erstellen.
2. Designs anschauen und HTML-Struktur sowie wiederverwendbare CSS-Patterns planen.
3. Zuerst semantisches HTML aufbauen.
4. Basis-Styles definieren (Schrift, Grundabstände, Layout).
5. Von oben nach unten stylen und regelmässig testen.
6. JavaScript ergänzen (Accordion-Toggle + Tastaturbedienung).
7. Responsiveness und Accessibility testen (Tastatur, Fokus, verschiedene Screen-Grössen).

Viel Spass beim Bauen! 🚀
