-- Setup-Skript für die Datenbank noten_db
-- Achtung: Dieses Skript löscht eine eventuell vorhandene Datenbank noten_db

DROP DATABASE IF EXISTS noten_db;

CREATE DATABASE noten_db
  CHARACTER SET utf8mb4
  COLLATE utf8mb4_unicode_ci;

USE noten_db;

-- =========================================
-- Tabellen anlegen
-- =========================================

CREATE TABLE lernende (
  id INT AUTO_INCREMENT PRIMARY KEY,
  vorname   VARCHAR(50)  NOT NULL,
  nachname  VARCHAR(50)  NOT NULL,
  klasse    VARCHAR(20)  NOT NULL,
  email     VARCHAR(100) NOT NULL
) ENGINE=InnoDB;

CREATE TABLE module (
  id INT AUTO_INCREMENT PRIMARY KEY,
  modulname    VARCHAR(100) NOT NULL,
  modulkuerzel VARCHAR(20)  NOT NULL
) ENGINE=InnoDB;

CREATE TABLE noten (
  id INT AUTO_INCREMENT PRIMARY KEY,
  lernende_id INT NOT NULL,
  modul_id    INT NOT NULL,
  note        DECIMAL(3,1) NOT NULL,
  geprueft_am DATE NOT NULL,
  CONSTRAINT fk_noten_lernende
    FOREIGN KEY (lernende_id)
    REFERENCES lernende(id)
    ON DELETE CASCADE,
  CONSTRAINT fk_noten_modul
    FOREIGN KEY (modul_id)
    REFERENCES module(id)
    ON DELETE CASCADE
) ENGINE=InnoDB;

-- =========================================
-- Beispieldaten einfügen
-- =========================================

INSERT INTO lernende (id, vorname, nachname, klasse, email) VALUES
  (1, 'Lena',   'Müller',    'INF23a', 'lena.mueller@example.ch'),
  (2, 'Tim',    'Keller',    'INF23a', 'tim.keller@example.ch'),
  (3, 'Aylin',  'Schneider', 'INF23b', 'aylin.schneider@example.ch'),
  (4, 'Jonas',  'Meier',     'INF23b', 'jonas.meier@example.ch');

INSERT INTO module (id, modulname, modulkuerzel) VALUES
  (1, 'Datenbanken und SQL',        'M290'),
  (2, 'Programmieren Grundlagen',   'M100'),
  (3, 'Allgemeinbildung',           'ABU');

INSERT INTO noten (lernende_id, modul_id, note, geprueft_am) VALUES
  -- Lena (INF23a)
  (1, 1, 5.0, '2025-01-15'),
  (1, 2, 5.5, '2025-01-20'),
  (1, 3, 4.5, '2025-01-25'),

  -- Tim (INF23a)
  (2, 1, 4.0, '2025-01-15'),
  (2, 2, 4.5, '2025-01-20'),
  (2, 3, 5.0, '2025-01-25'),

  -- Aylin (INF23b)
  (3, 1, 5.5, '2025-01-16'),
  (3, 2, 5.0, '2025-01-21'),
  (3, 3, 5.5, '2025-01-26'),

  -- Jonas (INF23b)
  (4, 1, 3.5, '2025-01-16'),
  (4, 2, 4.0, '2025-01-21'),
  (4, 3, 4.5, '2025-01-26');